<?php

/**************************************************************************\
*                                                                          *
*  This is a drop-in replacement for formmail.pl/cgi or mailform.pl/cgi    * 
*                                                                          *
*  Written by:  Noah Hearle                                                *
*  Site:        http://designextreme.net                                   *
*  Date:        28/12/2010                                                 *
*  Version:     1.01                                                       *
*                                                                          *
\**************************************************************************/

/* SETTINGS */

$data = array(
	'recipient_name' => 'Your Name',
	'recipient_email' => 'your@email.com',
	'subject' => 'Site Mail',
	'redirect' => '/thanks/'
);

/* ACTUAL CODE */

function sanitize(&$array)
{
	if (is_array($array))
	{
		foreach ($array as &$data)
		{
			if (is_array($data))
			{
				sanitize($data, $type);
			}
			else
			{
				$data = trim(stripslashes($data));
			}
		}
	}
}

function ppr($array,$exit=TRUE)
{
	if (is_array($array))
	{
		echo '<pre>'.print_r((array)$array,1).'</pre>';
	}
	else
	{
		echo '<pre>'.$array.'</pre>';
	}
	if ($exit)
	{
		exit;
	}
}

function email ($data)
{
	$sender_email = (string)$data['sender_email'];
	$sender_name = (string)$data['sender_name'];
	$return_email = (isset($data['return_email'])) ? (string)$data['return_email'] : (string)$data['sender_email'];
	$recipient_email = (string)$data['recipient_email'];
	$recipient_name = (string)$data['recipient_name'];
	$subject = (string)$data['subject'];
	$text = $data['text'];
	$html = $data['html'];
	
	$sender = $sender_name.' <'.$sender_email.'>';
	$recipient = $recipient_name.' <'.$recipient_email.'>';
	$headers = 'From: '.$sender.''."\r\n";
	$headers .= 'Reply-To: '.$sender_email.''."\r\n";
	$headers .= 'X-Mailer: PHP/'.phpversion()."\r\n";

	return mail($recipient, $subject, $text, $headers, '-f '.$return_email);	
}

if (isset($_GET['image'])) { image($_GET['image']); }

$postdata = $_POST;
sanitize($postdata);
$messagedata = array();
$errors = array();
$spam = FALSE;
$required = array();
if (isset($postdata['required']))
{
	$required_temp = explode(',',$postdata['required']);
	foreach ($required_temp as $k)
	{
		$required[] = trim($k);
	}
}
$ignore = array();
if (isset($postdata['ignore']))
{
	$ignore_temp = explode(',',$postdata['ignore']);
	foreach ($ignore_temp as $k)
	{
		$ignore[] = trim($k);
	}
}

foreach ($postdata as $k => $v)
{
	$k = trim(preg_replace('/[^\s\w_.-]/i','',$k));
	switch (strtolower($k))
	{
	case 'ignore' :
	case 'required' :
		break;
	case 'subject' :
		$v = preg_replace('/[^[:alnum:][:space:]\(\)\|,._-]+/i','',$v);
		if ($v == NULL)
		{
			$errors[] = 'The subject is empty.';
			break;
		} 
		if (strlen($v) < 3)
		{
			$errors[] = 'The subject: '.htmlspecialchars($v).' is invalid.';
			break;
		}
		if (spam_check($v))
		{
			$spam = TRUE;
			break(2);
		}
		$data['subject'] = $v;
		break;
	case 'realname' :
		$v = iconv('UTF-8','UTF-8//IGNORE',$v);
		if ($v == NULL)
		{
			$errors[] = 'The sender\'s name is empty.';
			break;
		} 
		if (strlen($v) < 3)
		{
			$errors[] = 'The sender\'s name: '.htmlspecialchars($v).' is invalid.';
			break;
		}
		if (spam_check($v))
		{
			$spam = TRUE;
			break(2);
		}
		$data['sender_name'] = $v;
		break;
	case 'email' :
		$v = preg_replace('/[,;]/','',$v);
		if ($v == NULL)
		{
			$errors[] = 'The sender\'s email address is empty.';
			break;
		}
		if (!preg_match('/^\w+([-+.]\w+)*@(\w+([-.]\w+)*\.\w+([-.]\w+)*)$/i',$v))
		{
			$errors[] = 'The email address: '.htmlspecialchars($v).' is invalid.';
			break;
		}
		if (!checkdnsrr(preg_replace('/[^@]*@([^@]+)$/','$1',$v), 'MX'))
		{
			$errors[] = 'The email address: '.htmlspecialchars($v).' does not resolve to a valid server.';
			break;
		}
		$data['sender_email'] = $v;
		break;
	case 'redirect' :
		if (preg_match('~^[\w/_.,\?&=-]+$~',$v))
		{
			$data['redirect'] = $v;
		}
		break;
	default :
		if (is_array($v))
		{
			$v = implode(', ',$v);
		}
		$v = iconv('UTF-8','UTF-8//IGNORE',$v);
		if (spam_check($v))
		{
			$spam = TRUE;
			break(2);
		}
		if (in_array($k,$ignore))
		{
			break;
		}
		if (in_array($k,$required) and $v == NULL)
		{
			$errors[] = 'The value in field: '.htmlspecialchars($k).' is empty.';
			break;
		}
		if (in_array($k,$required) and preg_match('/e[_-]?mail/i',$k))
		{
			if (!preg_match('/^\w+([-+.]\w+)*@(\w+([-.]\w+)*\.\w+([-.]\w+)*)$/i',$v))
			{
				$errors[] = 'The email address: '.htmlspecialchars($v).' is invalid.';
				break;
			}
			if (!checkdnsrr(preg_replace('/[^@]*@([^@]+)$/','$1',$v), 'MX'))
			{
				$errors[] = 'The email address: '.htmlspecialchars($v).' does not resolve to a valid server.';
				break;
			}
		}
		if ($v != NULL)
		{
			$messagedata[] = htmlspecialchars(preg_replace('/[_\s]+/',' ',$k)).': '.$v;
		}
		break;
	}
}
if ($spam)
{
	$heading = 'Spam!';
	$page_message = '<p>There is input data that contains spam words. This form will not be sent.</p>';
}
elseif ($errors)
{
	if (!isset($heading))
	{
		$heading = 'Validation Error';
	}
	if (count($errors) == 1)
	{
		$page_message = '<p>Sorry, there is a validation error in the form. '.htmlspecialchars($errors[0]).'</p>
';
	}
	else
	{
		$page_message = '<p>Sorry, there are validation errors in the form&hellip;</p>
<ul>
';
		foreach ($errors as $error)
		{
			$page_message .= '  <li>'.htmlspecialchars($error).'</li>
';
		}
		$page_message .= '</ul>
';
	}
	$page_message .= '<p>Please <a href="javascript:history.back();">go back</a> to make your corrections.</p>
';
}
if (!$spam and !empty($messagedata) and empty($errors) and count($data) >= 5)
{
	$divider = '___________________________________________________________________________';
	$message = $data['sender_name'].' <'.$data['sender_email'].'> on '.date('r').'.';
	$message .= "\r\n".$divider."\r\n\r\n";
	$message .= implode("\r\n\r\n",$messagedata);
	$message .= "\r\n\r\n".$divider."\r\n";
	$data['text'] = $message;
	if (email($data))
	{
		if (preg_match('~^[\w/_.,-]+$~',$data['redirect']))
		{
			header('Location: '.$data['redirect']);
		}
		$page_message = '<p>Thank you for sending your email!</p>';
	}
}
if (!isset($heading) or !$heading)
{
	$heading = 'Mail Form';
}
if (!isset($page_message) or !$page_message)
{
	$page_message = '<p>No data has been sent.</p>';
}
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>Mail Form</title>
<style type="text/css">
<!--

body {
	color: #222;
	margin: 0;
	background: #CCC;
	font: 13px Calibri, Verdana;
}
html {
	height: 100%;
	width: 100%;
}
a, a:link, a:visited, a:active, a:hover {
	color: #3C426F;
}
#main {
	display: block;
	background-color: #E0E0E0;
	padding: 10px 20px;
	width: 50%;
	vertical-align: middle;
	border: 2px solid #9E9E9E;
	margin: 50px auto;
	border-radius: 10px;
	-moz-border-radius: 10px;
	box-shadow: 5px 5px 10px #AAA;
	-moz-box-shadow: 5px 5px 10px #AAA;
	background: -webkit-gradient(
		linear,
		left bottom,
		left top,
		color-stop(0.26, rgb(180,180,180)),
		color-stop(0.63, rgb(196,196,196)),
		color-stop(0.82, rgb(209,209,209))
	);
	background: -moz-linear-gradient(
		center bottom,
		rgb(180,180,180) 26%,
		rgb(196,196,196) 63%,
		rgb(209,209,209) 82%
	);
}
li {
	list-style-type: square;
}
h1 {
	margin-top: 4px;
	color: #555;
	font-size: 24px;
	border-bottom: 1px dashed #888;
	padding: 0 0 4px 30px;
}
#main #logo {
	position: relative;
	z-index: 10;
	height: 64px;
	width: 64px;
	bottom: 38px;
	float: left;
	right: 52px;
	margin-bottom: -64px;
}
p {
	clear: left;
}

-->
</style>
</head>

<body>
<div id="main">
<div id="logo"><img src="<?= preg_replace('/index\.php$/','',$_SERVER['PHP_SELF']).'?image=alert.png' ?>" alt=" " width="64" height="64" border="0" title="Alert" /></div>
<h1><?= $heading; ?></h1>
<?= $page_message; ?>
</div>
</body>
</html>
<?php
function image ($filename)
{
	header('Content-Type: image/png');
	switch (strtolower($filename))
	{
	case 'alert.png':
		$data = <<<EOD
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%3D
EOD;
		break;
	default:
		break;
	}
	print base64_decode($data);
	exit;
}

function spam_check ($text)
{
	/* Checks text for spam-like characteristics */
	if ($text == NULL or !is_string($text))
	{
		return FALSE;
	}
	$text = trim($text,'\s');
	// Detect crap like: wYuZKoxZVkeqeikETvL and RButbCleIjSxUqqruDr
	if (preg_match('/^[[:alnum:]]+[a-z][A-Z]+[[:alnum:]]+[a-z][A-Z]+[[:alnum:]]+$/u',$text))
	{
		return TRUE;
	}
	// List SPAM words
	$spam_list = <<<EOD
 credit cards 
 free chat 
 free taxes 
 free virtual 
 hair loss
 meds 
 pills 
 seo 
 slot machines 
 virtual strip 
a href
airline
alprazolam
ambien
arse
asian
auscultation
avlimilplete
blackjack
bondage
bontril
britneyrules
browsing 
bugger
buisness
cash credit
cash register
casino
celebrex
cialis
contains information
content=0;
credit machine
cunt
electronic-dance
fetish
fuck
gambling
good stuff
greatnow
guardan_angel
hardcoreover
hold em
holdem
hold-em
href=
http-equiv
i like your website
latest news
levitra
loans
machine register
manikin
menopause
mortgage
multiweb
my dick
narod
nextworld
omaha
orthopedic
our products
 oversea 
palpation
phentermine
phentermine
picture register
 poker 
poker rooms
pokertexas
resuscitation
ripway
rulez
screen touch
 sitemap 
studs
suppliment
tramadol
url=
viagra
vicodin
wank
web4u
xanax
[url
EOD;
	$spam_list = preg_quote($spam_list,'~');	
	$spam_list = preg_replace("/\n/",'|',$spam_list);	
	return (preg_match('~'.$spam_list.'~i',$text));
}
?>